<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\Notification\NotificationTable;

final class NotificationModel extends AbstractModel implements InterfaceNotificationGetter
{
    /**
     * getter interface
     */
    use TraitNotificationGetters;

    public function getTableClassName(): string
    {
        return NotificationTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | helper methods
    |--------------------------------------------------------------------------
    */

    public function isTransient(): bool
    {
        return NotificationEnum::META_IS_TRANSIENT_YES == $this -> getMetaIsTransient();
    }
}
